/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50IOFailOverPool;
import com.ibm.hsc.rep.v50.R50PCISlot;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class OmCecActResourceUpdater {
    private OmCecMgr mCecMgr;
    private HSCEventIndicationMgr mIndMgr = null;

    public OmCecActResourceUpdater(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
        this.mIndMgr = HSCEventIndicationMgr.getInstance();
    }

    public void updateAddIoSlotOwnerAndPoolId(String string, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt16) {
        try {
            RObject rObject = this.addAllocatedSlotAssociation(string, unsignedInt32);
            if (rObject != null) {
                if (unsignedInt16 != null && !unsignedInt16.equals((Object)new UnsignedInt16(65535))) {
                    this.addIoSlotInFailOverAssoc(rObject, unsignedInt16);
                } else {
                    this.removeIoSlotInFailOverAssoc(rObject);
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error in updateAddIoSlotOwnerAndPoolId...");
            throwable.printStackTrace();
        }
    }

    public void updateRemoveIoSlotOwnerAndPoolId(UnsignedInt32 unsignedInt32) {
        try {
            RObject rObject = this.removeAllocatedSlotAssociations(unsignedInt32);
            if (rObject != null) {
                this.removeIoSlotInFailOverAssoc(rObject);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error in updateRemoveIoSlotOwnerAndPoolId...");
            throwable.printStackTrace();
        }
    }

    private RObject addAllocatedSlotAssociation(String string, UnsignedInt32 unsignedInt32) throws RException {
        OmLparMgr omLparMgr = this.mCecMgr.getLparMgr(string);
        RObject rObject = this.mCecMgr.getObject();
        RObject rObject2 = omLparMgr.getObject();
        RObject rObject3 = (RObject)rObject2.clone();
        RObject rObject4 = null;
        RObject rObject5 = null;
        Enumeration enumeration = null;
        RObject rObject6 = null;
        String string2 = null;
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_UsingIODrawer);
        if (vector == null) {
            return null;
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            rObject5 = (RObject)enumeration2.nextElement();
            Vector vector2 = rObject5.associators(R50Define.AID_IBMHSC_IODrawerSlot);
            if (vector2 == null) continue;
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                rObject6 = (RObject)enumeration.nextElement();
                string2 = (String)rObject6.getProperty(R50PCISlot.Index_DeviceID);
                if (!string2.equals(unsignedInt32.toString())) continue;
                rObject4 = rObject6;
                System.out.println("Found slot: " + rObject4);
            }
        }
        if (rObject4 != null) {
            System.out.println("****Adding allocated slot association!");
            boolean bl = false;
            Vector vector3 = rObject4.associators(R50Define.AID_IBMHSC_AllocatedSlot);
            if (vector3 != null && vector3.size() > 0) {
                for (int i = 0; i < vector3.size(); ++i) {
                    RObject rObject7 = (RObject)vector3.elementAt(i);
                    String string3 = (String)rObject7.getProperty("Name");
                    String string4 = string3.substring(string3.indexOf(42) + 1);
                    if (!string4.equals(this.mCecMgr.getCecName())) continue;
                    if (string3.equals(omLparMgr.getLparName())) {
                        bl = true;
                        continue;
                    }
                    rObject4.deleteAssociation(R50Define.AID_IBMHSC_AllocatedSlot, rObject7.getObjectId());
                }
            }
            if (!bl) {
                rObject4.addAssociation(R50Define.AID_IBMHSC_AllocatedSlot, rObject2.getObjectId());
            }
        }
        return rObject4;
    }

    private RObject removeAllocatedSlotAssociations(UnsignedInt32 unsignedInt32) throws RException {
        Vector vector;
        RObject rObject = this.mCecMgr.getObject();
        RObject rObject2 = null;
        RObject rObject3 = null;
        Enumeration enumeration = null;
        RObject rObject4 = null;
        String string = null;
        Vector vector2 = rObject.associators(R50Define.AID_IBMHSC_UsingIODrawer);
        if (vector2 == null) {
            return null;
        }
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            rObject3 = (RObject)enumeration2.nextElement();
            vector = rObject3.associators(R50Define.AID_IBMHSC_IODrawerSlot);
            if (vector == null) continue;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                rObject4 = (RObject)enumeration.nextElement();
                string = (String)rObject4.getProperty(R50PCISlot.Index_DeviceID);
                if (!string.equals(unsignedInt32.toString())) continue;
                rObject2 = rObject4;
                System.out.println("Found slot: " + rObject2);
            }
        }
        if (rObject2 != null && (vector = rObject2.associators(R50Define.AID_IBMHSC_AllocatedSlot)) != null) {
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                RObject rObject5 = (RObject)enumeration3.nextElement();
                rObject2.deleteAssociation(R50Define.AID_IBMHSC_AllocatedSlot, rObject5.getObjectId());
                System.out.println("****Deleted allocated slot association!");
            }
        }
        return rObject2;
    }

    private void addIoSlotInFailOverAssoc(RObject rObject, UnsignedInt16 unsignedInt16) throws RException {
        RObject rObject2 = this.mCecMgr.getObject();
        RObjectId rObjectId = new RObjectId(rObject2.getNameSpaceId(), R50Define.CID_IBMHSC_IOFailOverPool);
        rObjectId.setKeyValue(0, this.mCecMgr.getCecName());
        rObjectId.setKeyValue(1, "IBMHSC_ComputerSystem");
        rObjectId.setKeyValue(2, unsignedInt16.toString());
        RObject rObject3 = rObjectId.getObject();
        if (rObject3 == null) {
            rObject3 = new RObject(rObjectId);
            rObject3.addInstance();
            rObject3.addAssociation(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mCecMgr.getObjectId());
        }
        this.removeIoSlotInFailOverAssoc(rObject);
        System.out.println("****Adding slotInIOFailOver association!");
        rObject.addAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool, rObjectId);
    }

    private void removeIoSlotInFailOverAssoc(RObject rObject) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInIOFailOverPool);
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            RObject rObject2 = null;
            while (enumeration.hasMoreElements()) {
                rObject2 = (RObject)enumeration.nextElement();
                String string = (String)rObject2.getProperty(R50IOFailOverPool.Index_ComputerSystemCreationClassName);
                if (string.equals(this.mCecMgr.getCecName())) {
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool, rObject2.getObjectId());
                }
                if (rObject2.hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool) || rObject2.hasAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool)) continue;
                rObject2.deleteInstance();
            }
        }
    }
}

